<?php

class InteriorAction extends CAction
{
	/**
	 * obsługa wnętrza zlecenia
	 */
	private function _interiorZlecenia()
	{
		$idFirmy = Yii::app()->user->id_firmy;
		$turaAktywna = Yii::app()->user->getState('tura_aktywna');

		$maxIloscZlecen = Firma::getMaximumTasksCount($idFirmy);

		$activeTasksCount = Firma::getActiveTasksCount($idFirmy, Yii::app()->user->id_klasy);

		$zlecenia = ZlecenieFirmy::model()
			->with('idZlecenia0.odpowiedziZlecenia', 'idZlecenia0.dziedzina', 'kontrahent',
				'tenderGroup.firmy', 'worker', 'uczen')
			->findAll(array(
				'condition' => '"t"."idFirmy" = :idFirmy or ("tenderGroup"."id" is not null and
					"firmy"."idFirmy" = :idFirmy and "tenderGroup"."status" >= :tgStatus
					and "firmy"."status" >= :tfStatus)',
				'order' => '"t"."czasPodjecia" desc',
				'params' => array(
					':idFirmy' => $idFirmy,
					':tgStatus' => PrzetargGrupa::TENDER_STATUS_ACCEPTED,
					':tfStatus' => PrzetargFirma::STATUS_ACCEPTED
				)
		));

		$workersList = Firma::getWorkersList($idFirmy);

		$now = time();
		foreach ($zlecenia as $zlecenie)
			$zlecenie->checkStatus($now);

		$this->getController()->renderPartial('_interior_zlecenia', array(
			'zlecenia' => $zlecenia,
			'tura_aktywna' => $turaAktywna,
			'MAX_TASKS' => $maxIloscZlecen,
			'workersList' => $workersList,
			'TASK_NUM' => $activeTasksCount
		));
	}

	private function _interiorIntUPs1()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '6'
		));
	}

	private function _interiorIntUPs2()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '1'
		));
	}

	private function _interiorIntZs_rca()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '10'
		));
	}

	private function _interiorIntZs_dra()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '9'
		));
	}

	private function _interiorIntZs_zua()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '11'
		));
	}

	private function _interiorIntUSs_nip()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '4'
		));
	}

	private function _interiorIntUSs_vat7()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '5'
		));
	}

	private function _interiorIntUSs_vat7k()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '7'
		));
	}

	private function _interiorIntUSs_pit36()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '3'
		));
	}

	private function _interiorIntUSs_vatr()
	{
		$this->getController()->renderPartial('_interior_form', array(
			'formid' => '8'
		));
	}

	private function _interiorInternetBankowosc()
	{
		$firma = Firma::model()->with(array('bank'))->findByPk(Yii::app()->user->id_firmy);
		if (empty($firma))
			throw new CHttpException(404, 'Brak firmy - brak dostpu.');
		$oplaty = Oplaty::model()->with(array('kontrahent'))->findAll(array(
			'condition' => '"t"."idFirmy" = :idFirmy AND ("t"."czas" IS NOT NULL OR "t"."wartosc" <= 0)',
			'order' => '"t"."czas" DESC',
			'params' => array(
				':idFirmy' => Yii::app()->user->id_firmy
			)
		));
		$kontrahenci = Chtml::listData(Kontrahent::model()->findAll(), 'id', 'nazwa');
		$this->getController()->renderPartial('_interiorHTML_computer', array(
			'hash' => 'internetBankowosc',
			'firma' => $firma,
			'oplaty' => $oplaty,
			'kontrahenci' => $kontrahenci
		));
	}

	private function _interiorDokumenty()
	{
		$idFirmy = Yii::app()->user->id_firmy;
		$forms = FormularzUzytkownika::model()->with(array('formularz', 'uzytkownik',
			'uzytkownik.firma'))->findAll(array(
			'condition'=>'"firma"."id"=:idFirmy',
			'params'=>array(':idFirmy'=>$idFirmy)
		));
		$certyfikaty = SzkolenieFirmy::model()->with(array('idSzkolenia0', 'idSzkolenia0.dziedzina'))->findAll(array(
			'condition' => '"t"."idFirmy" = :idFirmy AND "t"."czySukces" > 0
				AND "t"."dataZakonczenia" <= SYSDATE',
			'params' => array(':idFirmy' => $idFirmy),
			'order' => '"t"."dataZakonczenia" DESC'
		));
		$this->getController()->renderPartial('_interiorHTML_computer', array(
			'hash' => 'dokumenty',
			'forms' => $forms,
			'certyfikaty' => $certyfikaty
		));
	}

	private function _interiorFinanse()
	{
		$fakturyVat = Faktury::model()->findAll(array(
			'condition' => '"t"."idFirmy" = :idFirmy AND "t"."czyKoszt" = 0',
			'params' => array(':idFirmy' => Yii::app()->user->id_firmy),
			'order' => '"t"."dataPlatnosci" DESC'
		));
		$fakturyKoszt = Faktury::model()->findAll(array(
			'condition' => '"t"."idFirmy" = :idFirmy AND "t"."czyKoszt" > 0',
			'params' => array(':idFirmy' => Yii::app()->user->id_firmy),
			'order' => '"t"."dataPlatnosci" DESC'
		));
		$bookNotes = ZlecenieFirmy::model()
			->with(array('idFirmy0.biura.budynek.mapa', 'idZlecenia0.dziedzina', 'kontrahent'))
			->findAll(array(
				'condition' => '"t"."idFirmy" = :idFirmy AND "t"."czasPodjecia" IS NOT NULL AND
					"t"."czasZakonczenia" IS NOT NULL AND "t"."idOdpowiedzi" IS NULL',
				'params' => array(':idFirmy' => Yii::app()->user->id_firmy),
				'order' => '"t"."czasPodjecia" DESC'
			)
		);

                $bookNotesNew = ZlecenieFirmy::model()->getBookNotes(Yii::app()->user->id_firmy);

		$this->getController()->renderPartial('_interiorHTML_computer', array(
			'hash' => 'finanse',
			'fakturyVat' => $fakturyVat,
			'fakturyKoszt' => $fakturyKoszt,
			'bookNotes' => $bookNotes,
                        'bookNotesNew'=>$bookNotesNew
		));
	}

	private function _interiorStatystyki()
	{
		$classId = Yii::app()->user->id_klasy;
		$companyId = Yii::app()->user->id_firmy;
		$punkty = Firma::getBusinessPointsInClassArray($classId);
		foreach ($punkty as $punkt)
		{
			$name = trim($punkt['nazwa']);
			$punkt['nazwa'] = empty($name) ? 'brak nazwy' : $name;
		}
		$certifikaty = Firma::getCompanyCertificatesCount($classId);
		$zyski = Firma::getValueRecords($classId);
		$maxLvls = Firma::getMaxLevels($companyId);
		$ratios = Firma::getDziedzinaReputation($companyId);
		$realLvls = Firma::getReputationsArr($maxLvls, $ratios);
		$dziedziny = Dziedzina::listAll();
		$this->getController()->renderPartial('_interiorHTML_computer',array(
			'hash' => 'statystyki',
			'punkty' => $punkty,
			'certifikaty' => $certifikaty,
			'zyski' => $zyski,
			'maxLvls' => $maxLvls,
			'ratios' => $ratios,
			'realLvls' => $realLvls,
			'dziedziny' => $dziedziny
		));
	}

	private function _interiorPracownicy()
	{
		$pracownicy = Pracownik::model()->findAll(array(
			'join' => 'LEFT JOIN "PracownikFirmy" "pf" ON "t"."id" = "pf"."idPracownika"',
			'condition' => '"pf"."idFirmy" = :idFirmy',
			'params' => array(
				':idFirmy' => Yii::app()->user->id_firmy
			)
		));
		$pracownikPunkty = PunktyDziedzinyPracownika::model()->findAll(array(
			'join' => 'LEFT JOIN "PracownikFirmy" "pf" ON "t"."idPracownika" = "pf"."idPracownika"',
			'condition' => '"pf"."idFirmy" = :idFirmy',
			'params' => array(
				':idFirmy' => Yii::app()->user->id_firmy
			)
		));
		$pracownikFirmy = PracownikFirmy::model()->findAll(array(
			'condition' => '"idFirmy" = :idFirmy',
			'params' => array(
				':idFirmy' => Yii::app()->user->id_firmy
			)
		));
		$punkty = array();
		$wynagrodzenia = array();
		$datyZatrudnienia = array();
		foreach ($pracownikPunkty as $punkt)
		{
			$punkty[(int) $punkt->idPracownika][$punkt->nazwa] = $punkt->punkty;
		}

		foreach ($pracownikFirmy as $pfirmy)
		{
			$wynagrodzenia[(int) $pfirmy->idPracownika] = $pfirmy->wynagrodzenie;
			$datyZatrudnienia[(int) $pfirmy->idPracownika] = $pfirmy->dataZatrudnienia;
		}
		$this->getController()->renderPartial('_interiorHTML_computer', array(
			'hash' => 'pracownicy',
			'pracownicy' => $pracownicy,
			'punkty' => $punkty,
			'wynagrodzenia' => $wynagrodzenia,
			'datyZatrudnienia' => $datyZatrudnienia
		));
	}

	private function _interiorSkrzynka()
	{
		$wiadomosciJson = UserData::getNewsHeadlinesJsonString();
		$wiadomosci = json_decode($wiadomosciJson,true);
		$this->getController()->renderPartial('_interiorHTML_computer', array(
			'hash' => 'skrzynka',
			'messages' => $wiadomosci
		));
	}

	static private $_centra = array(
		1 => array(	//matematyka
			'idDziedziny' => 1
		),
		2 => array(	//biologia
			'idDziedziny' => 3
		),
		3 => array(	//fizyka
			'idDziedziny' => 2
		),
		4 => array(	//chemia
			'idDziedziny' => 4
		),
	);

	private function centrumSzkolenioweLista($centrumTag)
	{
		if (!isset(self::$_centra[$centrumTag]))
			throw new CHttpException(404, 'Nieznane centrum szkoleniowe.');

		$company = Firma::model()->findByPk(Yii::app()->user->id_firmy);

		//verify all finished exams
		SzkolenieFirmy::checkPendingExams($company);

		$szkolenia = Yii::app()->db->createCommand('
			select
				"t"."id", "t"."nazwa", "t"."poziom", "t"."czyEgzamin", "t"."cena", "t"."czasTrwania",
				"sf"."id" "idProby", "sf"."czySukces", "sf"."dataRozpoczecia", "sf"."dataZakonczenia", "sf"."zgloszone"
			from "Szkolenie" "t"
			left join "SzkolenieFirmy" "sf" ON "t"."id" = "sf"."idSzkolenia" AND "sf"."idFirmy" = :idFirmy
			where "t"."idDziedzina" = :idDziedziny
			order by "t"."poziom", "t"."id", "sf"."dataZakonczenia" DESC NULLS FIRST, "sf"."czySukces" DESC
		')->queryAll(true, array(
			':idFirmy' => Yii::app()->user->id_firmy,
			':idDziedziny' => self::$_centra[$centrumTag]['idDziedziny']
		));

		$result = array();
		foreach ($szkolenia as $szkolenie)
			if (!isset($result[$szkolenie['id']])) {
				$szkolenie['poziomStr'] = Szkolenie::getPoziomString($szkolenie['poziom']);
				if ($szkolenie['czyEgzamin'])
					$szkolenie['czasTrwania'] = Szkolenie::getCzasTrwaniaString($szkolenie['czasTrwania']);
				$result[$szkolenie['id']] = (object)$szkolenie;
			}

		static $backInterior = array(
			1 => 'intCS1r',
			2 => 'centrumSzkoleniowe2',
			3 => 'intCS3r',
			4 => 'intCS4r',
		);

		$vat = ParametryGry::getValue('PODATEK_VAT', 0.23);

		$this->getController()->renderPartial('_interior_trainingCenterList', array(
			'szkolenia' => $result,
			'backInterior' => $backInterior[$centrumTag],
			'vat' => $vat
		));
	}

	private function _interiorIntCS1e() {
		$this->centrumSzkolenioweLista(1);
	}
	private function _interiorIntCS2e() {
		$this->centrumSzkolenioweLista(2);
	}
	private function _interiorIntCS3e() {
		$this->centrumSzkolenioweLista(3);
	}
	private function _interiorIntCS4e() {
		$this->centrumSzkolenioweLista(4);
	}

	private function centrumSzkolenioweSzkolenie($centrumTag)
	{
		if (!isset(self::$_centra[$centrumTag]))
			throw new CHttpException(404, 'Nieznane centrum szkoleniowe.');

		//szkolenie zapisane w window.temporatyTrainingData

		$this->getController()->renderPartial('_interior_trainingCenterTraining', array(
			'centrumTag' => $centrumTag
		));
	}

	private function _interiorIntCS1s() {
		$this->centrumSzkolenioweSzkolenie(1);
	}
	private function _interiorIntCS2s() {
		$this->centrumSzkolenioweSzkolenie(2);
	}
	private function _interiorIntCS3s() {
		$this->centrumSzkolenioweSzkolenie(3);
	}
	private function _interiorIntCS4s() {
		$this->centrumSzkolenioweSzkolenie(4);
	}

	private function centrumSzkolenioweEgzamin($centrumTag)
	{
		if (!isset(self::$_centra[$centrumTag]))
			throw new CHttpException(404, 'Nieznane centrum szkoleniowe.');

		//szkolenie zapisane w window.temporatyExamData

		$this->getController()->renderPartial('_interior_trainingCenterExam', array(
			'centrumTag' => $centrumTag
		));
	}

	private function _interiorIntCS1b() {
		$this->centrumSzkolenioweEgzamin(1);
	}
	private function _interiorIntCS2b() {
		$this->centrumSzkolenioweEgzamin(2);
	}
	private function _interiorIntCS3b() {
		$this->centrumSzkolenioweEgzamin(3);
	}
	private function _interiorIntCS4b() {
		$this->centrumSzkolenioweEgzamin(4);
	}

	private function _interiorIntUSr2()
	{
		$this->getController()->renderPartial('_interior_intUSr2');
	}
	private function _interiorIntUS1r2()
	{
		$this->getController()->renderPartial('_interior_intUSr2');
	}
	private function _interiorIntUS2r2()
	{
		$this->getController()->renderPartial('_interior_intUSr2');
	}
	private function _interiorIntUS3r2()
	{
		$this->getController()->renderPartial('_interior_intUSr2');
	}

	private function _interiorIntZr2()
	{
		$this->getController()->renderPartial('_interior_intZr2');
	}

	private function _interiorIntUPr1()
	{
		$this->getController()->renderPartial('_interior_intUPr1');
	}

	private function _interiorIntUPr2()
	{
		$this->getController()->renderPartial('_interior_intUPr2', array(
			'idAgencji' => 0, 'cena' => 0
		));
	}
	private function _interiorIntAPPr1()
	{
		$this->getController()->renderPartial('_interior_intUPr2', array(
			'idAgencji' => 1, 'cena' => (float)ParametryGry::getValue('CENA_APP', 300)
		));
	}
	private function _interiorIntAPPr2()
	{
		$this->getController()->renderPartial('_interior_intUPr2', array(
			'idAgencji' => 1, 'cena' => (float)ParametryGry::getValue('CENA_APP', 300)
		));
	}

	private function biuroZleceniaR($interiorId)
	{
		$companyId = Yii::app()->user->id_firmy;
		$classId = Yii::app()->user->id_klasy;

		$kontrahentId = filter_input(INPUT_POST, 'kontrahentId', FILTER_VALIDATE_INT);

		$kontrahent = Kontrahent::model()->findByPk($kontrahentId);
		if (empty($kontrahent))
			throw new CHttpException(404, 'Nie można zlokalizować kontrahenta.');

		$canCooperate = $kontrahent->canCooperate($companyId);
		$tasks = 0;
		$tenders = 0;
		$maxTasks = 0;
		$lessonActive = Akcja::isLessonActive();

		if ($canCooperate && $lessonActive)
		{
			$tasks = Firma::getActiveTasksCount($companyId, $classId);
			$maxTasks = Firma::getMaximumTasksCount($companyId);
			$tenders = Kontrahent::isTenderAvileable($kontrahentId);
		}

		$vat = ParametryGry::getValue('PODATEK_VAT', 0.23);

		$this->getController()->renderPartial('_interior_biuroZleceniaXR', array(
			'kontrahent' => $kontrahent,
			'interiorId' => $interiorId,
			'maxTasks' => $maxTasks,
			'tasks' => $tasks,
			'canCooperate' => $canCooperate,
			'tenders' => $tenders,
			'lessonActive' => $lessonActive,
			'vat' => $vat
		));
	}

	private function _interiorBiuroZlecenia1r() {
		$this->biuroZleceniaR(1);
	}
	private function _interiorBiuroZlecenia2r() {
		$this->biuroZleceniaR(2);
	}

	private function biuroZleceniaX($interiorId)
	{
		$buildingId = filter_input(INPUT_POST, 'buildingId', FILTER_VALIDATE_INT);

		//get kontrahent by building
		$kontrahent = Kontrahent::model()->findByAttributes(array('idBudynku'=>$buildingId));
		if (empty($kontrahent))
			throw new CHttpException(404, 'Nie można zlokalizować kontrahenta.');

		$this->getController()->renderPartial('_interior_biuroZleceniaX', array(
			'interiorId' => $interiorId,
			'kontrahent' => $kontrahent,
		));
	}

	private function _interiorBiuroZlecenia1() {
		$this->biuroZleceniaX(1);
	}
	private function _interiorBiuroZlecenia2() {
		$this->biuroZleceniaX(2);
	}

	private function agencjaReklamowaXR($interiorId)
	{
		$kampania = Kampanie::model()->findByAttributes(array(
			'idBudynku' => $interiorId,
			'idRodzajKampanii' => Kampanie::TYPE_LOGO
		));
		if (empty($kampania))
			throw new CHttpException(404, 'Nie ma podanej agencji.');

		$kampanie = Yii::app()->db->createCommand('select distinct "t"."id",
			"t"."cenaDzien",
			"t"."cenaMiesiac",
			"t"."cenaTydzien",
			"kf"."czasRozpoczecia",
			"kf"."czasZakonczenia",
			"rodzaj"."nazwa",
			"t"."bonus"
		from "Kampanie" "t"
		left join "RodzajKampanii" "rodzaj" on "rodzaj"."id" = "t"."idRodzajKampanii"
		left join "KampaniaFirmy" "kf" on "kf"."idKampanii" = "t"."id" and
			"kf"."idFirmy" = :companyId and "kf"."czasZakonczenia" >= sysdate
		where "t"."idRodzajKampanii" > 0 and "t"."idBudynku" = :idBudynku AND "t"."jezyk" is null
		order by "rodzaj"."nazwa"')->queryAll(true, array(
			':idBudynku' => $interiorId,
			':companyId' => Yii::app()->user->id_firmy
		));
		foreach ($kampanie as $idx => $k)
		{
			$kampanie[$idx]['czasRozpoczecia'] = strtotime($k['czasRozpoczecia']);
			$kampanie[$idx]['czasZakonczenia'] = strtotime($k['czasZakonczenia']);
		}

		$kampanieEn = Yii::app()->db->createCommand('select distinct "t"."id",
			"t"."cenaDzien",
			"t"."cenaMiesiac",
			"t"."cenaTydzien",
			"kf"."czasRozpoczecia",
			"kf"."czasZakonczenia",
			"rodzaj"."nazwa",
			"t"."bonus"
		from "Kampanie" "t"
		left join "RodzajKampanii" "rodzaj" on "rodzaj"."id" = "t"."idRodzajKampanii"
		left join "KampaniaFirmy" "kf" on "kf"."idKampanii" = "t"."id" and
			"kf"."idFirmy" = :companyId and "kf"."czasZakonczenia" >= sysdate
		where "t"."idRodzajKampanii" > 0 and "t"."idBudynku" = :idBudynku AND "t"."jezyk" is not null
		order by "rodzaj"."nazwa"')->queryAll(true, array(
			':idBudynku' => $interiorId,
			':companyId' => Yii::app()->user->id_firmy
		));
		foreach ($kampanieEn as $idx => $k)
		{
			$kampanieEn[$idx]['czasRozpoczecia'] = strtotime($k['czasRozpoczecia']);
			$kampanieEn[$idx]['czasZakonczenia'] = strtotime($k['czasZakonczenia']);
		}

		$loga = $kampania->getLogos('Matematyka', 'Fizyka', 'Biologia', 'Chemia');

		$maxDiscount = $kampania->calculateDiscount(Yii::app()->user->id_firmy);

		$vat  = ParametryGry::getValue('PODATEK_VAT', 0.23);

		$this->getController()->renderPartial('_interior_intARXr', array(
			'interiorId' => $interiorId,
			'kampania' => $kampania,
			'loga' => $loga,
			'kampanie' => $kampanie,
			'kampanieEn' => $kampanieEn,
			'maxDiscount' => $maxDiscount,
			'vat' => $vat
		));
	}

	private function _interiorIntAR1r() {
		$this->agencjaReklamowaXR(1);
	}
	private function _interiorIntAR2r() {
		$this->agencjaReklamowaXR(2);
	}
	private function _interiorIntAR3r() {
		$this->agencjaReklamowaXR(3);
	}

	private function bankTalkX($bankId, $talkId)
	{
		$company = Firma::model()->findByPk(Yii::app()->user->id_firmy);
		if (empty($company))
			throw new CHttpException(404, 'Nie można odnaleźć firmy.');
		$this->getController()->renderPartial('_interiorIntBankXrY', array(
			'company' => $company,
			'bankId' => $bankId
		));
	}

	private function _interiorIntBank1r1() {
		$this->bankTalkX(1, 1);
	}
	private function _interiorIntBank2r1() {
		$this->bankTalkX(2, 1);
	}
	private function _interiorIntBank2r2() {
		$this->bankTalkX(2, 2);
	}
	private function _interiorIntBank3r1() {
		$this->bankTalkX(3, 1);
	}
	private function _interiorIntBank3r2() {
		$this->bankTalkX(3, 2);
	}
	private function _interiorIntBank4r1() {
		$this->bankTalkX(4, 1);
	}
	private function _interiorIntBank4r2() {
		$this->bankTalkX(4, 2);
	}

	public function run($hash = null)
	{
		header('Content-type: text/html; charset=utf-8');

		if (empty($hash))
			$hash = filter_input(INPUT_POST, 'hash', FILTER_SANITIZE_STRING);
		else
			$hash = filter_var($hash, FILTER_SANITIZE_STRING);

		if (!Akcja::isInteriorAllowed($hash))
			throw new CHttpException(404, 'Akcja jest zablokowana.');

		$method = '_interior' . ucfirst($hash);
		if (method_exists($this, $method))
			$this->$method();
		else
			$this->getController()->renderPartial('_interiorHTML_computer', array(
				'hash' => $hash
			));
	}
}
